/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

class DeviceClassProperties {
    private static final String TRACE_MASKT = "XMDADCPT";
    private static final String TRACE_MASKF = "XMDADCPF";
    private static final String TRACE_MASKD = "XMDADCPD";
    private int[] mediaSupported;
    private boolean ejectable;
    private boolean lockable;
    private boolean formattable;
    private boolean readOnly;
    private String dosDrive;
    private int[] fileSystems;
    private String labelScript;
    private boolean massWritable;
    private boolean massReadOnly;
    private String deviceType;
    private int numberOfDevices;
    private static final String TRUE = "true";
    private static final String DEVICE_TYPE = "device.type";
    private static final String DEVICE_MEDIA_EJECTABLE = "device.media.ejectable";
    private static final String DEVICE_MEDIA_FORMATTABLE = "device.media.formattable";
    private static final String DEVICE_DOOR_LOCKABLE = "device.door.lockable";
    private static final String DEVICE_READONLY = "device.readonly";
    private static final String DEVICE_MEDIA_SUPPORTED = "device.media.supported";
    private static final String DEVICE_FILESYSTEMS = "device.filesystems";
    private static final String DEVICE_LABEL_SCRIPT = "device.label.script";
    private static final String DEVICE_MASS_WRITABLE = "device.mass.writable";
    private static final String DEVICE_MASS_READONLY = "device.mass.readonly";
    private static final String DEVICE_DOS_DRIVE = "device.dos.drive";

    DeviceClassProperties(String deviceClassPropertiesFileName) throws Exception {
        Trace.trace(TRACE_MASKT, "-> DeviceClassProperties.DeviceClassProperties(deviceClassPropertiesFileName = " + deviceClassPropertiesFileName + ")");
        try {
            this.initializeProperties(deviceClassPropertiesFileName);
        }
        catch (Exception exc) {
            throw new Exception(exc.getMessage());
        }
        this.numberOfDevices = 0;
        Trace.trace(TRACE_MASKT, "<- DeviceClassProperties.DeviceClassProperties()");
    }

    void incrementNumberOfDevices() {
        Trace.trace(TRACE_MASKT, "-> DeviceClassProperties.incrementNumberOfDevices()");
        ++this.numberOfDevices;
        Trace.trace(TRACE_MASKT, "<- DeviceClassProperties.incrementNumberOfDevices()");
    }

    int[] getMediaSupported() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.getMediaSupported()");
        return this.mediaSupported;
    }

    int[] getFileSystems() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.getFileSystems()");
        return this.fileSystems;
    }

    String getLabelScript() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.getLabelScript(): returns " + this.labelScript);
        return this.labelScript;
    }

    String getDosDrive() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.getDosDrive(): returns " + this.dosDrive);
        return this.dosDrive;
    }

    String getDeviceType() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.getDeviceType(): returns " + this.deviceType);
        return this.deviceType;
    }

    int getNumberOfDevices() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.getNumberOfDevices(): returns " + this.numberOfDevices);
        return this.numberOfDevices;
    }

    boolean isEjectable() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.isEjectable(): returns " + this.ejectable);
        return this.ejectable;
    }

    boolean isLockable() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.isLockable(): returns " + this.lockable);
        return this.lockable;
    }

    boolean isFormattable() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.isFormattable(): returns " + this.formattable);
        return this.formattable;
    }

    boolean isReadOnly() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.isReadOnly(): returns " + this.readOnly);
        return this.readOnly;
    }

    boolean isMassWritable() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.isMassWritable(): returns " + this.massWritable);
        return this.massWritable;
    }

    boolean isMassReadOnly() {
        Trace.trace(TRACE_MASKT, "<> DeviceClassProperties.isMassReadOnly(): returns " + this.massReadOnly);
        return this.massReadOnly;
    }

    boolean isMediaSupported(int mediaType) {
        if (mediaType == 6) {
            Trace.trace(TRACE_MASKF, "DeviceClassProperties.isMediaSupported(): mediaType == 6");
            if (this.isMassWritable()) {
                Trace.trace(TRACE_MASKF, "DeviceClassProperties.isMediaSupported(): device supports mass writable media.");
                return true;
            }
            Trace.trace(TRACE_MASKF, "DeviceClassProperties.isMediaSupported(): device does not support mass writable media.");
            return false;
        }
        if (mediaType == 7) {
            Trace.trace(TRACE_MASKF, "DeviceClassProperties.isMediaSupported(): mediaType == 7");
            if (this.isMassReadOnly()) {
                Trace.trace(TRACE_MASKF, "DeviceClassProperties.isMediaSupported(): device supports mass read-only media.");
                return true;
            }
            Trace.trace(TRACE_MASKF, "DeviceClassProperties.isMediaSupported(): device does not support mass read-only media.");
            return false;
        }
        boolean mediaSupport = false;
        for (int i = 0; i < this.mediaSupported.length; ++i) {
            if (mediaType != this.mediaSupported[i]) continue;
            Trace.trace(TRACE_MASKF, "DeviceClassProperties.isMediaSupported(): " + mediaType + " = " + this.mediaSupported[i]);
            mediaSupport = true;
            break;
        }
        return mediaSupport;
    }

    private void initializeProperties(String deviceClassPropertiesFileName) throws Exception {
        Trace.trace(TRACE_MASKT, "-> DeviceClassProperties.initializeProperties(deviceClassPropertiesFileName = " + deviceClassPropertiesFileName + ")");
        try {
            FileInputStream deviceClassPropertiesFile = new FileInputStream(deviceClassPropertiesFileName);
            Properties deviceClassProperties = new Properties();
            deviceClassProperties.load(deviceClassPropertiesFile);
            deviceClassPropertiesFile.close();
            this.deviceType = deviceClassProperties.getProperty(DEVICE_TYPE);
            this.ejectable = deviceClassProperties.getProperty(DEVICE_MEDIA_EJECTABLE).equals(TRUE);
            this.formattable = deviceClassProperties.getProperty(DEVICE_MEDIA_FORMATTABLE).equals(TRUE);
            this.lockable = deviceClassProperties.getProperty(DEVICE_DOOR_LOCKABLE).equals(TRUE);
            this.readOnly = deviceClassProperties.getProperty(DEVICE_READONLY).equals(TRUE);
            this.mediaSupported = this.parsedIntegerArray(deviceClassProperties.getProperty(DEVICE_MEDIA_SUPPORTED));
            this.fileSystems = this.parsedIntegerArray(deviceClassProperties.getProperty(DEVICE_FILESYSTEMS));
            this.labelScript = deviceClassProperties.getProperty(DEVICE_LABEL_SCRIPT);
            this.massWritable = deviceClassProperties.getProperty(DEVICE_MASS_WRITABLE).equals(TRUE);
            this.massReadOnly = deviceClassProperties.getProperty(DEVICE_MASS_READONLY).equals(TRUE);
            this.dosDrive = deviceClassProperties.getProperty(DEVICE_DOS_DRIVE);
        }
        catch (Exception exc) {
            throw new Exception("caught error trying to instantiate properties: " + exc.getMessage());
        }
        Trace.trace(TRACE_MASKT, "<- DeviceClassProperties.initializeProperties()");
    }

    private int[] parsedIntegerArray(String csvIntArray) {
        Trace.trace(TRACE_MASKT, "-> DeviceClassProperties.parsedIntegerArray(csvIntArray = " + csvIntArray + ")");
        StringTokenizer st = new StringTokenizer(csvIntArray);
        int stlength = st.countTokens();
        int[] array = new int[stlength];
        for (int i = 0; i < stlength; ++i) {
            array[i] = new Integer(st.nextToken());
        }
        Trace.trace(TRACE_MASKT, "<- DeviceClassProperties.parsedIntegerArray()");
        return array;
    }
}

